package com.example.sefinsa_app.ui.reporteCreditos;

import androidx.annotation.RequiresApi;

import android.annotation.SuppressLint;
import android.app.ProgressDialog;
import android.content.ContentValues;
import android.content.Context;
import android.content.DialogInterface;
import android.content.SharedPreferences;
import android.content.pm.ActivityInfo;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.os.Build;
import android.os.Bundle;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import android.text.Editable;
import android.text.Html;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.AutoCompleteTextView;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.example.sefinsa_app.R;
import com.example.sefinsa_app.api.API;
import com.example.sefinsa_app.controllers.PoblacionController;
import com.example.sefinsa_app.controllers.ReporteCreditosController;
import com.example.sefinsa_app.controllers.RutaController;
import com.example.sefinsa_app.migrations.DatabaseHelper;
import com.example.sefinsa_app.models.Poblacion;
import com.example.sefinsa_app.models.ReporteCreditos;
import com.example.sefinsa_app.models.Ruta;
import com.example.sefinsa_app.utilities.CurrentFragment;
import com.example.sefinsa_app.utilities.ErrorChecker;
import com.example.sefinsa_app.utilities.ReporteCreditosAdapter;
import com.example.sefinsa_app.utilities.Utils;
import com.example.sefinsa_app.utilities.Validator;
import com.example.sefinsa_app.utilities.VolleyS;
import com.google.android.material.chip.Chip;
import com.google.android.material.chip.ChipGroup;
import com.google.android.material.datepicker.MaterialDatePicker;
import com.google.android.material.datepicker.MaterialPickerOnPositiveButtonClickListener;
import com.google.android.material.dialog.MaterialAlertDialogBuilder;
import com.google.android.material.textfield.TextInputEditText;
import com.google.android.material.textfield.TextInputLayout;
import com.google.gson.Gson;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.TimeZone;
import java.util.stream.Collectors;

public class ReporteCreditosFragment extends Fragment {

    private ReporteCreditosViewModel mViewModel;

    private SharedPreferences sesion;

    private ArrayList<ReporteCreditos> reporteCreditos, reporteCreditosFiltrado, reportesFiltradosNombres, reportesAgregados;

    private TextInputLayout tlFecha, tlRuta, tlNombre;

    private Button btnGuardar, btnTotales, btnAgregar;

    private VolleyS vs;
    private RequestQueue requestQueue;

    private ArrayList<Ruta> rutas;
    private ArrayAdapter<Ruta> rutasAdapter;

    private RutaController rutaController;

    private String ruta_id = "";
    private int previousLength;
    private boolean backSpace;

    private static ProgressDialog dialog;

    private RecyclerView recyclerView;
    private ReporteCreditosAdapter reporteCreditosAdapter;
    private LinearLayoutManager linearLayoutManager;

    private AutoCompleteTextView rutasAutoCompleteTextView;

    private boolean buscarReporte = false;

    private TextInputEditText svPoblaciones;

    private ReporteCreditosController reporteCreditosController;

    ArrayList<Poblacion> poblaciones;
    ArrayAdapter<Poblacion> poblacionesAdapter;

    String poblacion_id = "", poblacion_nombre = "";

    private PoblacionController poblacionController;


    public static ReporteCreditosFragment newInstance() {
        return new ReporteCreditosFragment();
    }

    @Override
    public void onViewStateRestored(@Nullable Bundle savedInstanceState) {
        super.onViewStateRestored(savedInstanceState);
        rutasAutoCompleteTextView.setText("", false);
        if(svPoblaciones != null)
            svPoblaciones.setText("");
    }
    @Override
    public void onCreateOptionsMenu(@NonNull Menu menu, @NonNull MenuInflater inflater) {
        super.onCreateOptionsMenu(menu, inflater);
    }
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container,
                             @Nullable Bundle savedInstanceState) {
        setHasOptionsMenu(true);
        requireActivity().setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_UNSPECIFIED);
        return inflater.inflate(R.layout.fragment_reporte_creditos, container, false);
    }

    private void getNuevoReporteCreditosOnline() {
        dialog = new ProgressDialog(getActivity(), R.style.AppMaterialAlertDialogStyle);
        dialog.setMessage("Cargando datos, por favor espere...");
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();

        vs = VolleyS.getInstance(getActivity());
        requestQueue = vs.getRequestQueue();

        JSONObject data = new JSONObject();
        try {
            data.put("func", "getReporteCreditosAPP");
            data.put("empleado_id", sesion.getString("id", ""));
        } catch (JSONException e) {
            e.printStackTrace();
        }

        JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlPagos, data,
                new Response.Listener<JSONObject>() {
                    @Override
                    public void onResponse(JSONObject response) {
                        try {
                            if (response.getString("status").equals("success")) {
                                JSONArray reportesArray = response.getJSONArray("data");

                                // Preparar arrays separados
                                JSONArray reporteArray = new JSONArray();

                                // Separar datos de reportes y gastos
                                for (int i = 0; i < reportesArray.length(); i++) {
                                    JSONObject reporteCompleto = reportesArray.getJSONObject(i);

                                    // Extraer datos de reporte
                                    JSONObject reporte = new JSONObject();
                                    reporte.put("id", reporteCompleto.getString("id"));
                                    reporte.put("poblacion_id", reporteCompleto.getString("poblacion_id"));
                                    reporte.put("observaciones", reporteCompleto.getString("observaciones"));
                                    reporte.put("creditos_otorgados", reporteCompleto.getString("creditos_otorgados"));
                                    reporte.put("total_prestamos", reporteCompleto.getString("total_prestamos"));
                                    reporte.put("prestamos_nuevos", reporteCompleto.getString("prestamos_nuevos"));
                                    reporte.put("monto_nuevos", reporteCompleto.getString("monto_nuevos"));
                                    reporte.put("prestamos_renovados", reporteCompleto.getString("prestamos_renovados"));
                                    reporte.put("monto_renovados", reporteCompleto.getString("monto_renovados"));
                                    reporte.put("empleado_id", reporteCompleto.getString("empleado_id"));
                                    reporte.put("fecha", reporteCompleto.getString("fecha"));
                                    reporte.put("fecha_registro", reporteCompleto.getString("fecha_registro"));
                                    reporteArray.put(reporte);
                                }

                                // Insertar datos en SQLite
                                insertarDatosEnSQLite(reporteArray);

                                dialog.dismiss();
                                Toast.makeText(getActivity(), "Datos sincronizados correctamente", Toast.LENGTH_SHORT).show();
                            } else {
                                dialog.dismiss();
                                Toast.makeText(getActivity(), "No se encontraron datos para sincronizar", Toast.LENGTH_SHORT).show();
                            }
                        } catch (JSONException e) {
                            dialog.dismiss();
                            e.printStackTrace();
                            Toast.makeText(getActivity(), "Error al procesar datos del servidor", Toast.LENGTH_SHORT).show();
                        }
                    }

                }, new Response.ErrorListener() {
            @Override
            public void onErrorResponse(VolleyError error) {
                dialog.cancel();
                ErrorChecker.checker(error, getActivity());
            }
        });

        request.setRetryPolicy(new DefaultRetryPolicy(
                5000,
                DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

        request.setShouldCache(false);
        requestQueue.add(request);
    }

    private void insertarDatosEnSQLite(JSONArray reporteArray) {
        DatabaseHelper dbHelper = new DatabaseHelper(getActivity());
        SQLiteDatabase db = dbHelper.getWritableDatabase();

        try {
            db.beginTransaction(); // Inicia una transacción para mejorar el rendimiento

            // Insertar reportes en la tabla `reporte_diario_rutas`
            for (int i = 0; i < reporteArray.length(); i++) {
                JSONObject reporte = reporteArray.getJSONObject(i);
                ContentValues values = new ContentValues();

                values.put("id", reporte.getString("id"));
                values.put("poblacion_id", reporte.getString("poblacion_id"));
                values.put("observaciones", reporte.getString("observaciones"));
                values.put("creditos_otorgados", reporte.getString("creditos_otorgados"));
                values.put("total_prestamos", reporte.getString("total_prestamos"));
                values.put("prestamos_nuevos", reporte.getString("prestamos_nuevos"));
                values.put("monto_nuevos", reporte.getString("monto_nuevos"));
                values.put("prestamos_renovados", reporte.getString("prestamos_renovados"));
                values.put("monto_renovados", reporte.getString("monto_renovados"));
                values.put("empleado_id", reporte.getString("empleado_id"));
                values.put("fecha", reporte.getString("fecha"));
                values.put("fecha_registro", reporte.getString("fecha_registro"));

                db.insertWithOnConflict("reporte_creditos", null, values, SQLiteDatabase.CONFLICT_REPLACE);
            }

            db.setTransactionSuccessful(); // Marca la transacción como exitosa
        } catch (JSONException e) {
            e.printStackTrace();
        } finally {
            db.endTransaction(); // Finaliza la transacción
            db.close();
        }
    }

    @Override
    public boolean onOptionsItemSelected(@NonNull MenuItem item) {
        switch (item.getItemId()) {
            case R.id.action_refresh:
                //Log.d("ReporteCreditosFragment", "Refresh seleccionado...................");

                // Luego llama a getNuevoReporteDiarioRutasOnline()
                getNuevoReporteCreditosOnline();
                return true;
            default:
                return super.onOptionsItemSelected(item);
        }
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        CurrentFragment.fragment = "ReporteCreditoFragment";
        sesion = getActivity().getSharedPreferences("sesion", Context.MODE_PRIVATE);

        // Verificar si la tabla 'reporte_creditos' existe y tiene más de un registro
        if (isTableExistsAndHasData("reporte_creditos")) {
            getNuevoReporteCreditosUpd();
        } else {
            getNuevoReporteCreditosOnline();
            //Toast.makeText(getActivity(), "La tabla 'reporte_creditos' no existe o está vacía.", Toast.LENGTH_LONG).show();
        }

        initElements(view);
    }

    private boolean isTableExistsAndHasData(String tableName) {
        SQLiteDatabase db = null;
        Cursor cursor = null;
        boolean result = false;

        try {
            // Abrir base de datos en modo lectura
            db = new DatabaseHelper(getActivity()).getReadableDatabase();

            // Consulta para verificar si la tabla existe
            String queryTableExists = "SELECT name FROM sqlite_master WHERE type='table' AND name=?";
            cursor = db.rawQuery(queryTableExists, new String[]{tableName});

            if (cursor.getCount() > 0) { // La tabla existe
                cursor.close(); // Cerrar el cursor para reutilizar

                // Consulta para verificar si la tabla tiene más de un registro
                String queryTableHasData = "SELECT COUNT(*) FROM " + tableName;
                cursor = db.rawQuery(queryTableHasData, null);

                if (cursor.moveToFirst()) {
                    int rowCount = cursor.getInt(0); // Obtiene el conteo de registros
                    result = rowCount > 0; // Devuelve true si hay al menos un registro
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (cursor != null) {
                cursor.close();
            }
            if (db != null) {
                db.close();
            }
        }

        return result;
    }

    private List<ReporteCreditos> obtenerReportesPendientes() {
        List<ReporteCreditos> listaReportes = new ArrayList<>();
        DatabaseHelper dbHelper = new DatabaseHelper(requireContext());
        SQLiteDatabase db = dbHelper.getWritableDatabase();
        Cursor cursor = db.query("reporte_creditos", null, "status = ?", new String[]{"1"}, null, null, null);

        if (cursor.moveToFirst()) {
            do {
                ReporteCreditos reporte = new ReporteCreditos();
                reporte.setId(cursor.getString(cursor.getColumnIndexOrThrow("id")));
                reporte.setPoblacion_id(cursor.getString(cursor.getColumnIndexOrThrow("poblacion_id")));
                reporte.setObservaciones(cursor.getString(cursor.getColumnIndexOrThrow("observaciones")));
                reporte.setCreditos_otorgados(cursor.getString(cursor.getColumnIndexOrThrow("creditos_otorgados")));
                reporte.setTotal_prestamos(cursor.getString(cursor.getColumnIndexOrThrow("total_prestamos")));
                reporte.setPrestamos_nuevos(cursor.getString(cursor.getColumnIndexOrThrow("prestamos_nuevos")));
                reporte.setMonto_nuevos(cursor.getString(cursor.getColumnIndexOrThrow("monto_nuevos")));
                reporte.setPrestamos_renovados(cursor.getString(cursor.getColumnIndexOrThrow("prestamos_renovados")));
                reporte.setMonto_renovados(cursor.getString(cursor.getColumnIndexOrThrow("monto_renovados")));
                reporte.setEmpleado_id(cursor.getString(cursor.getColumnIndexOrThrow("empleado_id")));
                reporte.setFecha(cursor.getString(cursor.getColumnIndexOrThrow("fecha")));

                listaReportes.add(reporte);
            } while (cursor.moveToNext());
        }

        cursor.close();
        db.close();
        return listaReportes;
    }
    private void enviarReportesPendientes() {
        List<ReporteCreditos> reportes = obtenerReportesPendientes();
        Log.d("ReporteDebug", "Enviando reporte Lista completa: " + reportes.toString());
        for (ReporteCreditos reporte : reportes) {
            Log.d("ReporteDebug", "Enviando reporte: " + reporte.toString());
            registrarReporte2(reporte);
        }
    }
    private void registrarReporte2(ReporteCreditos reporteCreditos) {
        vs = VolleyS.getInstance(getActivity());
        requestQueue = vs.getRequestQueue();

        JSONObject data = new JSONObject();
        try {
            data.put("func", "createReporteCreditos");
            data.put("poblacion_id", reporteCreditos.getPoblacion_id());
            data.put("observaciones", reporteCreditos.getObservaciones());
            data.put("creditos_otorgados", reporteCreditos.getCreditos_otorgados());
            data.put("total_prestamos", reporteCreditos.getTotal_prestamos());
            data.put("prestamos_nuevos", reporteCreditos.getPrestamos_nuevos());
            data.put("montos_nuevos", reporteCreditos.getMonto_nuevos());
            data.put("prestamos_renovados", reporteCreditos.getPrestamos_renovados());
            data.put("montos_renovados", reporteCreditos.getMonto_renovados());
            data.put("empleado_id", sesion.getString("id", ""));
            data.put("fecha", reporteCreditos.getFecha());

        } catch (JSONException e) {
            e.printStackTrace();
        }

        JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlPagos, data,
                new Response.Listener<JSONObject>() {

                    @Override
                    public void onResponse(JSONObject response) {
                        try {
                            if (response.getString("status").equals("success")) {
                                // Obtener el ID devuelto por el servidor
                                String nuevoId = response.getJSONObject("data").getString("id");

                                Log.d("DEBUG", "ID devuelto por el servidor: " + nuevoId);

                                // Actualizar status y asignar ID en SQLite
                                actualizarReporteEnSQLite2(reporteCreditos.getId(), nuevoId);
                            }
                        } catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }
                }, new Response.ErrorListener() {

            @Override
            public void onErrorResponse(VolleyError error) {
                ErrorChecker.checker(error, getActivity());
            }
        });

        request.setRetryPolicy(new DefaultRetryPolicy(
                0,
                DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

        request.setShouldCache(false);
        requestQueue.add(request);
    }

    private void actualizarReporteEnSQLite2(String idLocal, String idServidor) {
        DatabaseHelper dbHelper = new DatabaseHelper(requireContext());
        SQLiteDatabase db = dbHelper.getWritableDatabase();
        ContentValues valores = new ContentValues();
        valores.put("status", 0);
        valores.put("id", idServidor); // Siempre actualizando con el ID del servidor

        // Usamos replace para evitar conflictos con la clave primaria
        db.replace("reporte_creditos", null, valores);

        db.close();
    }


    private void getNuevoReporteCreditosUpd() {
        dialog = new ProgressDialog(getActivity(), R.style.AppMaterialAlertDialogStyle);
        dialog.setMessage("Cargando datos, por favor espere...");
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();

        enviarReportesPendientes();

        vs = VolleyS.getInstance(getActivity());
        requestQueue = vs.getRequestQueue();
        //Log.d("DEBUG", "Entro en actualizar registros al INICIO...........");
        JSONObject data = new JSONObject();
        try {
            data.put("func", "getReporteCreditosAPP");
            data.put("empleado_id", sesion.getString("id", ""));
        } catch (JSONException e) {
            e.printStackTrace();
        }

        JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlPagos, data,
                new Response.Listener<JSONObject>() {
                    @Override
                    public void onResponse(JSONObject response) {
                        try {
                            if (response.getString("status").equals("success")) {
                                JSONArray reportesArray = response.getJSONArray("data");

                                // Preparar arrays separados
                                JSONArray reporteArray = new JSONArray();

                                // Separar datos de reportes y gastos
                                for (int i = 0; i < reportesArray.length(); i++) {
                                    JSONObject reporteCompleto = reportesArray.getJSONObject(i);

                                    // Extraer datos de reporte
                                    JSONObject reporte = new JSONObject();
                                    reporte.put("id", reporteCompleto.getString("id"));
                                    reporte.put("poblacion_id", reporteCompleto.getString("poblacion_id"));
                                    reporte.put("observaciones", reporteCompleto.getString("observaciones"));
                                    reporte.put("creditos_otorgados", reporteCompleto.getString("creditos_otorgados"));
                                    reporte.put("total_prestamos", reporteCompleto.getString("total_prestamos"));
                                    reporte.put("prestamos_nuevos", reporteCompleto.getString("prestamos_nuevos"));
                                    reporte.put("monto_nuevos", reporteCompleto.getString("monto_nuevos"));
                                    reporte.put("prestamos_renovados", reporteCompleto.getString("prestamos_renovados"));
                                    reporte.put("monto_renovados", reporteCompleto.getString("monto_renovados"));
                                    reporte.put("empleado_id", reporteCompleto.getString("empleado_id"));
                                    reporte.put("fecha", reporteCompleto.getString("fecha"));
                                    reporte.put("fecha_registro", reporteCompleto.getString("fecha_registro"));
                                    reporteArray.put(reporte);
                                }

                                // Insertar datos en SQLite
                                updateDatosEnSQLite(reporteArray);

                                dialog.dismiss();
                                Toast.makeText(getActivity(), "Datos sincronizados correctamente", Toast.LENGTH_SHORT).show();
                            } else {
                                dialog.dismiss();
                                Toast.makeText(getActivity(), "No se encontraron datos para sincronizar", Toast.LENGTH_SHORT).show();
                            }
                        } catch (JSONException e) {
                            dialog.dismiss();
                            e.printStackTrace();
                            Toast.makeText(getActivity(), "Error al procesar datos del servidor", Toast.LENGTH_SHORT).show();
                        }
                    }

                }, new Response.ErrorListener() {
            @Override
            public void onErrorResponse(VolleyError error) {
                dialog.cancel();
                ErrorChecker.checker(error, getActivity());
            }
        });

        request.setRetryPolicy(new DefaultRetryPolicy(
                5000,
                DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

        request.setShouldCache(false);
        requestQueue.add(request);
    }

    private void updateDatosEnSQLite(JSONArray reporteArray) {
        SQLiteDatabase db = new DatabaseHelper(getActivity()).getWritableDatabase();

        try {
            // Iterar a través de los reportes
            for (int i = 0; i < reporteArray.length(); i++) {
                JSONObject reporte = reporteArray.getJSONObject(i);

                String id = reporte.getString("id");
                String fecha_registro_servidor = reporte.getString("fecha_registro");

                // Log para ver el ID y la fecha de registro del servidor
                //Log.d("DEBUG", "Procesando reporte ID: " + id);
                //Log.d("DEBUG", "Fecha de registro del servidor para ID " + id + ": " + fecha_registro_servidor);

                // Obtener la fecha de registro de la base de datos SQLite
                String fecha_registro_local = getFechaRegistroSQLite(db, id);

                // Comparar las fechas
                if (isFechaMasReciente(fecha_registro_servidor, fecha_registro_local)) {
                    // Si la fecha del servidor es más reciente, hacer el UPDATE
                    //Log.d("DEBUG", "La fecha del servidor es más reciente para el reporte ID " + id);

                    // Realizar el UPDATE en SQLite con los nuevos datos del servidor
                    ContentValues values = new ContentValues();
                    values.put("poblacion_id", reporte.getString("poblacion_id"));
                    values.put("observaciones", reporte.getString("observaciones"));
                    values.put("creditos_otorgados", reporte.getString("creditos_otorgados"));
                    values.put("total_prestamos", reporte.getString("total_prestamos"));
                    values.put("prestamos_nuevos", reporte.getString("prestamos_nuevos"));
                    values.put("monto_nuevos", reporte.getString("monto_nuevos"));
                    values.put("prestamos_renovados", reporte.getString("prestamos_renovados"));
                    values.put("monto_renovados", reporte.getString("monto_renovados"));
                    values.put("empleado_id", reporte.getString("empleado_id"));
                    values.put("fecha", reporte.getString("fecha"));
                    values.put("fecha_registro", fecha_registro_servidor);

                    // Log para ver los valores que se van a actualizar en SQLite
                    //Log.d("DEBUG", "Valores a actualizar para el reporte ID " + id + ": " + values.toString());

                    // Actualizar los datos en SQLite
                    int rowsAffected = db.update("reporte_creditos", values, "id = ?", new String[]{id});

                    // Log para ver cuántas filas se afectaron
                    //Log.d("DEBUG", "Número de filas actualizadas para ID " + id + ": " + rowsAffected);
                } else {
                    Log.d("DEBUG", "La fecha del servidor no es más reciente para el reporte ID " + id);
                }
            }

            // No olvides cerrar la base de datos cuando hayas terminado
            db.close();

        } catch (JSONException e) {
            e.printStackTrace();
            Log.e("ERROR", "Error procesando el reporte: " + e.getMessage());
        }
    }

    // Método para obtener la fecha de registro desde SQLite
    private String getFechaRegistroSQLite(SQLiteDatabase db, String id) {
        String fecha_registro = "";

        Cursor cursor = db.rawQuery("SELECT fecha_registro FROM reporte_creditos WHERE id = ?", new String[]{id});

        if (cursor.moveToFirst()) {
            fecha_registro = cursor.getString(cursor.getColumnIndexOrThrow("fecha_registro"));

            // Si la fecha es null, asignamos la fecha actual
            if (fecha_registro == null) {
                // Obtener la fecha actual en el formato adecuado
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", new Locale("es", "MX"));
                fecha_registro = dateFormat.format(new Date()); // Asignamos la fecha actual

                // Actualizamos la base de datos con la nueva fecha
                actualizarFechaRegistroSQLite(db, id, fecha_registro);  // Llamada al método para actualizar la fecha
            }
        } else {
            Log.d("DEBUG", "No se encontró un registro para el ID: " + id);
        }
        cursor.close();

        return fecha_registro;
    }

    // Método para actualizar la fecha en la base de datos
    private void actualizarFechaRegistroSQLite(SQLiteDatabase db, String id, String fecha_registro) {
        ContentValues valores = new ContentValues();
        valores.put("fecha_registro", fecha_registro);

        // Actualiza la base de datos con la nueva fecha de registro
        int rowsAffected = db.update("reporte_creditos", valores, "id = ?", new String[]{id});
        if (rowsAffected > 0) {
            Log.d("DEBUG", "Fecha de registro actualizada correctamente para ID: " + id);
        } else {
            Log.d("DEBUG", "No se pudo actualizar la fecha de registro para ID: " + id);
        }
    }



    // Método para comparar dos fechas (servidor vs local)
    private boolean isFechaMasReciente(String fechaServidor, String fechaLocal) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", new Locale("es", "MX"));
            Date fechaServidorDate = dateFormat.parse(fechaServidor);
            Date fechaLocalDate = dateFormat.parse(fechaLocal);

            return Objects.requireNonNull(fechaServidorDate).after(fechaLocalDate); // Retorna true si la fecha del servidor es más reciente
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return false; // Si no se puede comparar, devuelve false por defecto
    }

    public void initElements(View view) {

        poblaciones = new ArrayList<>();
        reporteCreditosFiltrado = new ArrayList<>();
        poblacionController = new PoblacionController(getActivity());

        svPoblaciones = view.findViewById(R.id.svPoblaciones);

        svPoblaciones.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            @Override
            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            @Override
            public void afterTextChanged(Editable editable) {
                filtrarReportePoblaciones(editable.toString());
            }
        });
        reporteCreditosController = new ReporteCreditosController(getActivity());
        rutaController = new RutaController(getActivity());
        recyclerView = view.findViewById(R.id.rvReporteCreditos);
        rutasAutoCompleteTextView = view.findViewById(R.id.acRuta);
        reporteCreditos = new ArrayList<>();
        reportesAgregados = new ArrayList<>();

        rutas = new ArrayList<Ruta>();

        linearLayoutManager = new LinearLayoutManager(getContext());
        recyclerView.setLayoutManager(linearLayoutManager);
        reporteCreditosAdapter = new ReporteCreditosAdapter(getActivity(), reporteCreditos);
        recyclerView.setAdapter(reporteCreditosAdapter);

        btnGuardar = view.findViewById(R.id.btnGuardar);
        btnTotales = view.findViewById(R.id.btnTotales);
        btnAgregar = view.findViewById(R.id.btnAgregar);

        tlFecha = view.findViewById(R.id.tlFecha);
        tlRuta = view.findViewById(R.id.tlRuta);
        tlNombre = view.findViewById(R.id.tlNombre);

        tlNombre.getEditText().setText(sesion.getString("nombre", ""));

        tlFecha.getEditText().setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                MaterialDatePicker.Builder materialDateBuilder = MaterialDatePicker.Builder.datePicker();
                materialDateBuilder.setTitleText("Fecha");
                MaterialDatePicker materialDatePicker = materialDateBuilder.build();

                materialDatePicker.show(getChildFragmentManager(), "MATERIAL_DATE_PICKER");

                materialDatePicker.addOnPositiveButtonClickListener(
                        new MaterialPickerOnPositiveButtonClickListener() {

                            @SuppressLint("SetTextI18n")
                            @Override
                            public void onPositiveButtonClick(Object selection) {

                                TimeZone timeZoneUTC = TimeZone.getDefault();
                                int offsetFromUTC = timeZoneUTC.getOffset(new Date().getTime()) * -1;
                                SimpleDateFormat simpleFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
                                Date date = new Date((Long) selection + offsetFromUTC);

                                tlFecha.getEditText().setText(simpleFormat.format(date));
                            }
                        });
            }
        });

        getRutas();

        rutasAutoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener() {

            @RequiresApi(api = Build.VERSION_CODES.N)
            @Override
            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                Ruta ruta = rutasAdapter.getItem(i);
                ruta_id = ruta.getId();

                filtrarReporte(ruta_id);

            }
        });

        rutasAutoCompleteTextView.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                previousLength = s.length();
            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            @Override
            public void afterTextChanged(Editable s) {
                backSpace = previousLength > s.length();

                if (backSpace && !ruta_id.equals("")) {

                    ruta_id = "";
                    rutasAutoCompleteTextView.setText("");

                    reporteCreditosAdapter.setListaFiltrada(reporteCreditos);
                }

            }
        });

        new MaterialAlertDialogBuilder(getActivity())
                .setCancelable(false)
                .setTitle("Opciones")
                .setPositiveButton("Nuevo reporte", new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialogInterface, int i) {
                        buscarReporte = false;
                        reporteCreditosAdapter.setBuscarReporte(false);
                        getNuevoReporteDiarioRutas(null);

                    }
                })
                .setNegativeButton("Buscar", new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialogInterface, int i) {

                        buscarReporte = true;
                        reporteCreditosAdapter.setBuscarReporte(true);

                        tlFecha.getEditText().addTextChangedListener(new TextWatcher() {
                            @Override
                            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

                            }

                            @Override
                            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {

                            }

                            @Override
                            public void afterTextChanged(Editable editable) {

                                if(Validator.fieldValidation(tlRuta, "Ingresa una ruta"))
                                {
                                    getReporteCreditos(ruta_id, tlFecha.getEditText().getText().toString(), sesion.getString("id",""));
                                }

                            }
                        });

                    }
                })
                .show();


        btnAgregar.setOnClickListener(new View.OnClickListener() {
            @RequiresApi(api = Build.VERSION_CODES.N)
            @Override
            public void onClick(View view) {

                final View dialogView = LayoutInflater.from(getActivity()).inflate(R.layout.dialog_reporte_creditos_2, null, false);

                AutoCompleteTextView poblacionesAutoCompleteTextView = dialogView.findViewById(R.id.acPoblacion);
                Button btnAgregar = dialogView.findViewById(R.id.btnAgregar);
                TextInputLayout tlObservaciones = dialogView.findViewById(R.id.tlObservaciones);
                TextInputLayout tlMonto = dialogView.findViewById(R.id.tlMonto);
                TextInputLayout tlCantidad = dialogView.findViewById(R.id.tlCantidad);
                TextInputLayout tlTotalPrestamos = dialogView.findViewById(R.id.tlTotalPrestamos);
                TextInputLayout tlPrestamosNuevos = dialogView.findViewById(R.id.tlPrestamosNuevos);
                TextInputLayout tlMontoNuevos = dialogView.findViewById(R.id.tlMontoNuevos);
                TextInputLayout tlPrestamosRenovados = dialogView.findViewById(R.id.tlPrestamosRenovados);
                TextInputLayout tlMontoRenovados = dialogView.findViewById(R.id.tlMontoRenovados);
                ChipGroup chipGroup = dialogView.findViewById(R.id.chipGroup);
                TextView tvCreditos = dialogView.findViewById(R.id.tvCreditos);

                final String[] creditos_otorgados = {""};
                final String[] total = {"0"};

                /**
                 *  POBLACIONES ADAPTER PARA AUTOCOMPLETTEXTVIEW
                 */

                if (poblaciones.size() == 0) {
                    getPoblaciones(ruta_id);
                }

                List<Poblacion> poblacionesFiltro =
                        poblaciones.stream().filter(poblacion -> poblacion.getRuta_id().equals(ruta_id)).collect(Collectors.toList());

                poblacionesAdapter = new ArrayAdapter<Poblacion>(getContext(), android.R.layout.simple_dropdown_item_1line, poblacionesFiltro);

                poblacionesAutoCompleteTextView.setThreshold(1);
                poblacionesAutoCompleteTextView.setAdapter(poblacionesAdapter);

                poblacionesAutoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
                    @RequiresApi(api = Build.VERSION_CODES.N)
                    @Override
                    public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                        Poblacion poblacion = poblacionesAdapter.getItem(i);
                        poblacion_id = poblacion.getId();
                        poblacion_nombre = poblacion.getNombre_poblacion();

                    }
                });

                btnAgregar.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View view) {

                        if(Validator.fieldValidation(tlMonto, "Ingresa un monto") &&
                                Validator.fieldValidation(tlCantidad, "Ingresa una cantidad")){

                            Chip chip = new Chip(getActivity());
                            chip.setCloseIconVisible(true);
                            chip.setChipBackgroundColorResource(R.color.orange_700);
                            String chipText = "$"+tlMonto.getEditText().getText().toString()+ " (" + tlCantidad.getEditText().getText().toString()+")";
                            chip.setText(chipText);

                            chip.setOnCloseIconClickListener(new View.OnClickListener() {
                                @Override
                                public void onClick(View view) {
                                    creditos_otorgados[0] = creditos_otorgados[0].replace(chipText, "");
                                    chipGroup.removeView(chip);

                                }
                            });

                            creditos_otorgados[0] =  creditos_otorgados[0] + " "+ chipText;

                            chipGroup.addView(chip);

                            String[] creditosSplit = creditos_otorgados[0].trim().split("\\$");


                            int t = 0;

                            for(int i = 0; i < creditosSplit.length; i++) {

                                if(!creditosSplit[i].equals("") && !creditosSplit[i].equals("null ") && !creditosSplit[i].equals(" ")){
                                   t += Integer.parseInt(creditosSplit[i].split(" ")[1].replace("(","").replace(")", ""));
                                }

                            }

                            total[0] = String.valueOf(t);
                            tlTotalPrestamos.getEditText().setText(String.valueOf(t));

                            tlMonto.getEditText().setText("");
                            tlCantidad.getEditText().setText("");
                            tlMonto.requestFocus();

                        }

                    }
                });


                new MaterialAlertDialogBuilder(getActivity())
                        .setCancelable(false)
                        .setView(dialogView)
                        .setTitle("Agregar registro al reporte")
                        .setPositiveButton("Guardar", new DialogInterface.OnClickListener() {
                            @Override
                            public void onClick(DialogInterface dialogInterface, int i) {

                                if(!poblacion_id.equals("")){



                                    ReporteCreditos nuevoRegistro= new ReporteCreditos(
                                            "",
                                            poblacion_id,
                                            tlObservaciones.getEditText().getText().toString(),
                                            "",
                                            tlTotalPrestamos.getEditText().getText().toString(),
                                            tlPrestamosNuevos.getEditText().getText().toString(),
                                            tlMontoNuevos.getEditText().getText().toString(),
                                            tlPrestamosRenovados.getEditText().getText().toString(),
                                            tlMontoRenovados.getEditText().getText().toString(),
                                            "", "", poblacion_nombre, "", "",""
                                    );

                                    nuevoRegistro.setCreditos_otorgados(creditos_otorgados[0]);
                                    nuevoRegistro.setSeleccionado(true);

                                    String creditos_otorgados = "";

                                    if(nuevoRegistro.getChipGroupCreditos().size() > 0){
                                        for(Chip chip :  nuevoRegistro.getChipGroupCreditos()){
                                            creditos_otorgados += " " + chip.getText().toString();
                                        }
                                    }

                                    reportesAgregados.add(nuevoRegistro);
                                    reporteCreditos.add(nuevoRegistro);

                                    reporteCreditosAdapter.addAll(reporteCreditos);
                                    reporteCreditosAdapter.notifyItemRangeChanged(reporteCreditos.size(), 1);

                                    poblacion_id = "";
                                    poblacion_nombre = "";


                                }
                                else{

                                    Toast.makeText(getActivity(), "Selecciona una población", Toast.LENGTH_SHORT).show();

                                }

                            }
                        })
                        .setNegativeButton("Cerrar", new DialogInterface.OnClickListener() {
                            @Override
                            public void onClick(DialogInterface dialogInterface, int i) {

                            }
                        })
                        .show();

                }
            });

        btnGuardar.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                new MaterialAlertDialogBuilder(getActivity())
                        .setCancelable(false)
                        .setTitle("Guardar reporte")
                        .setMessage("¿Esta seguro de registrar el reporte?")
                        .setPositiveButton("Guardar", new DialogInterface.OnClickListener() {
                            @Override
                            public void onClick(DialogInterface dialogInterface, int i) {

                                if(Validator.fieldValidation(tlRuta, "Ingresa una ruta") &&
                                        Validator.fieldValidation(tlFecha, "Ingresa una fecha")
                                ){

                                    if(buscarReporte){

                                        if(reporteCreditos.size() > 0){

                                            if(reportesAgregados.size() > 0){

                                                for(ReporteCreditos rc: reportesAgregados){
                                                    rc.setSeleccionado(false);

                                                    agregarRegistroReporte(rc);
                                                }

                                                reportesAgregados.clear();

                                                Toast.makeText(getActivity(), "Se agregaron registros al reporte", Toast.LENGTH_LONG).show();

                                            }
                                            else{
                                                Toast.makeText(getActivity(), "No se agregaron nuevos registros", Toast.LENGTH_SHORT).show();

                                            }

                                            if(reporteCreditosAdapter.reportesEditados.size() > 0){

                                                for(ReporteCreditos rc: reporteCreditosAdapter.reportesEditados){
                                                    //Log.d("editReporteCreditos", "Datos SELECCIONADOS ID............: " + rc.getId());
                                                   editarRegistroReporte(rc);
                                                }
                                                reporteCreditosAdapter.reportesEditados.clear();

                                                Toast.makeText(getActivity(), "Se editaron registros del reporte", Toast.LENGTH_LONG).show();

                                            }
                                            else{
                                                Toast.makeText(getActivity(), "No se editaron nuevos registros", Toast.LENGTH_SHORT).show();

                                            }

                                        }

                                    }
                                    else{

                                        if(reporteCreditosAdapter.reportesSeleccionados.size() > 0){

                                            for(ReporteCreditos rc: reporteCreditosAdapter.reportesSeleccionados){
                                                rc.setSeleccionado(false);
                                                registrarReporte(rc);
                                            }

                                            reporteCreditosAdapter.reportesSeleccionados.clear();

                                            getNuevoReporteDiarioRutas(null);
                                            tlFecha.getEditText().setText("");
                                            rutasAutoCompleteTextView.setText("");

                                            Toast.makeText(getActivity(), "Se registro el reporte", Toast.LENGTH_SHORT).show();

                                        }
                                        else{
                                            Toast.makeText(getActivity(), "No hay poblaciones seleccionadas", Toast.LENGTH_SHORT).show();
                                        }

                                    }



                                }

                            }
                        })
                        .setNegativeButton("Cancelar", new DialogInterface.OnClickListener() {
                            @Override
                            public void onClick(DialogInterface dialogInterface, int i) {

                            }
                        })
                        .show();
            }
        });

        btnTotales.setOnClickListener(new View.OnClickListener() {
            @RequiresApi(api = Build.VERSION_CODES.N)
            @Override
            public void onClick(View view) {

                final View dialogView = LayoutInflater.from(getActivity()).inflate(R.layout.dialog_creditos_totales, null, false);

                TextView tvTotalPrestamos = dialogView.findViewById(R.id.tvTotalPrestamos);
                TextView tvPrestamosNuevos = dialogView.findViewById(R.id.tvPrestamosNuevos);
                TextView tvMontoNuevos = dialogView.findViewById(R.id.tvMontoNuevos);
                TextView tvPrestamosRenovados = dialogView.findViewById(R.id.tvPrestamosRenovados);
                TextView tvMontoRenovados = dialogView.findViewById(R.id.tvMontoRenovados);

                if(buscarReporte){

                    int totalPrestamos = reporteCreditos.stream()
                            .mapToInt(o -> Utils.parseInt(o.getTotal_prestamos()))
                            .sum();
                    tvTotalPrestamos.setText(Html.fromHtml("<b>Total prestamos: </b> "+totalPrestamos));

                    int prestamosNuevosTotal = reporteCreditos.stream()
                            .mapToInt(o -> Utils.parseInt(o.getPrestamos_nuevos()))
                            .sum();
                    tvPrestamosNuevos.setText(Html.fromHtml("<b>Prestamos nuevos: </b> "+prestamosNuevosTotal));

                    double montosNuevosTotal = reporteCreditos.stream()
                            .mapToDouble(o -> Utils.parseDouble(o.getMonto_nuevos()))
                            .sum();
                    tvMontoNuevos.setText(Html.fromHtml("<b>Montos nuevos: </b> $"+montosNuevosTotal));

                    int prestamosRenovadosTotal = reporteCreditos.stream()
                            .mapToInt(o -> Utils.parseInt(o.getPrestamos_renovados()))
                            .sum();
                    tvPrestamosRenovados.setText(Html.fromHtml("<b>Prestamos renovados: </b> "+prestamosRenovadosTotal));

                    double montosRenovadosTotal = reporteCreditos.stream()
                            .mapToDouble(o -> Utils.parseDouble(o.getMonto_renovados()))
                            .sum();
                    tvMontoRenovados.setText(Html.fromHtml("<b>Montos renovados: </b> $"+montosRenovadosTotal));

                }
                else{

                    int totalPrestamos = reporteCreditosAdapter.reportesSeleccionados.stream()
                            .mapToInt(o -> Utils.parseInt(o.getTotal_prestamos()))
                            .sum();
                    tvTotalPrestamos.setText(Html.fromHtml("<b>Total prestamos: </b> "+totalPrestamos));

                    int prestamosNuevosTotal = reporteCreditosAdapter.reportesSeleccionados.stream()
                            .mapToInt(o -> Utils.parseInt(o.getPrestamos_nuevos()))
                            .sum();
                    tvPrestamosNuevos.setText(Html.fromHtml("<b>Prestamos nuevos: </b> "+prestamosNuevosTotal));

                    double montosNuevosTotal = reporteCreditosAdapter.reportesSeleccionados.stream()
                            .mapToDouble(o -> Utils.parseDouble(o.getMonto_nuevos()))
                            .sum();
                    tvMontoNuevos.setText(Html.fromHtml("<b>Montos nuevos: </b> $"+montosNuevosTotal));

                    int prestamosRenovadosTotal = reporteCreditosAdapter.reportesSeleccionados.stream()
                            .mapToInt(o -> Utils.parseInt(o.getPrestamos_renovados()))
                            .sum();
                    tvPrestamosRenovados.setText(Html.fromHtml("<b>Prestamos renovados: </b> "+prestamosRenovadosTotal));

                    double montosRenovadosTotal = reporteCreditosAdapter.reportesSeleccionados.stream()
                            .mapToDouble(o -> Utils.parseDouble(o.getMonto_renovados()))
                            .sum();
                    tvMontoRenovados.setText(Html.fromHtml("<b>Montos renovados: </b> $"+montosRenovadosTotal));

                }

                new MaterialAlertDialogBuilder(getActivity())
                        .setCancelable(false)
                        .setView(dialogView)
                        .setTitle("Totales")
                        .setNegativeButton("Cerrar", new DialogInterface.OnClickListener() {
                            @Override
                            public void onClick(DialogInterface dialogInterface, int i) {

                            }
                        })
                        .show();



            }
        });

    }

    public void getRutas()
    {
        String rutaIdSesion = sesion.getString("rutas", "");
        //Log.d("getRutas", "Ruta ID de la sesión: " + rutaIdSesion);

        // Descomponer los IDs de la sesión en una lista
        List<String> rutaIdsSesion = Arrays.asList(rutaIdSesion.split(","));
        //Log.d("getRutas", "Ruta IDs de la sesión descompuestos: " + rutaIdsSesion);

        if(rutaController.obtener().size() == 0){

            vs = VolleyS.getInstance(this.getContext());
            requestQueue = vs.getRequestQueue();

            JSONObject data = new JSONObject();
            try {
                data.put("func", "rutasActivas");

            } catch (JSONException e) {
                e.printStackTrace();
            }

            JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlRutas, data,
                    new Response.Listener<JSONObject>() {

                        @Override
                        public void onResponse(JSONObject response) {
                            try {

                                JSONArray data = (JSONArray) response.get("data");

                                for(int i = 0; i < data.length(); i++){

                                    JSONObject obj = data.getJSONObject(i);

                                    Gson gson = new Gson();
                                    Ruta ruta = gson.fromJson(obj.toString(), Ruta.class);

                                    if (rutaIdsSesion.contains(ruta.getId())) {
                                        rutas.add(ruta);
                                        rutaController.nueva(ruta);
                                        //Log.d("getRutas", "Ruta añadida: " + ruta.toString());
                                    }

                                }

                                rutasAdapter = new ArrayAdapter<Ruta>(getContext(), android.R.layout.simple_dropdown_item_1line, rutas);
                                rutasAutoCompleteTextView.setThreshold(1);
                                rutasAutoCompleteTextView.setAdapter(rutasAdapter);

                            } catch (JSONException e) {
                                e.printStackTrace();
                            }
                        }
                    }, new Response.ErrorListener() {

                @Override
                public void onErrorResponse(VolleyError error) {

                    ErrorChecker.checker(error, getActivity());

                }
            }) ;

            request.setRetryPolicy(new DefaultRetryPolicy(
                    0,
                    DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                    DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

            requestQueue.add(request);

        }
        else{
            //Log.d("getRutas", "Recuperando rutas guardadas localmente.");
            List<Ruta> rutasGuardadas = rutaController.obtener();
            //Log.d("getRutas", "Cantidad de rutas locales encontradas: " + rutasGuardadas.size());

            for (Ruta ruta : rutasGuardadas) {
                //Log.d("getRutas", "Ruta local encontrada: " + ruta.toString());
                // Verificar si el ID de la ruta está en la lista de IDs de la sesión
                if (rutaIdsSesion.contains(ruta.getId())) {
                    rutas.add(ruta);
                    //Log.d("getRutas", "Ruta añadida tras filtrar: " + ruta);
                }
            }

            rutasAdapter = new ArrayAdapter<Ruta>(getContext(), android.R.layout.simple_dropdown_item_1line, rutas);
            rutasAutoCompleteTextView.setThreshold(1);
            rutasAutoCompleteTextView.setAdapter(rutasAdapter);
        }

    }

    private void logUltimosTresRegistros() {
        DatabaseHelper dbHelper = new DatabaseHelper(requireActivity());
        SQLiteDatabase db = dbHelper.getReadableDatabase();
        Cursor cursor = null;

        try {
            // Consulta para obtener los últimos 3 registros
            String query = "SELECT * FROM reporte_creditos ORDER BY id DESC LIMIT 5";
            cursor = db.rawQuery(query, null);

            if (cursor != null && cursor.moveToFirst()) {
                do {
                    // Obtener los datos de cada columna
                    int id = cursor.getInt(cursor.getColumnIndexOrThrow("id"));
                    String poblacion_id = cursor.getString(cursor.getColumnIndexOrThrow("poblacion_id"));
                    String observaciones = cursor.getString(cursor.getColumnIndexOrThrow("observaciones"));
                    String creditos_otorgados = cursor.getString(cursor.getColumnIndexOrThrow("creditos_otorgados"));
                    String total_prestamos = cursor.getString(cursor.getColumnIndexOrThrow("total_prestamos"));
                    String prestamos_nuevos = cursor.getString(cursor.getColumnIndexOrThrow("prestamos_nuevos"));
                    String monto_nuevos = cursor.getString(cursor.getColumnIndexOrThrow("monto_nuevos"));
                    String prestamos_renovados = cursor.getString(cursor.getColumnIndexOrThrow("prestamos_renovados"));
                    String monto_renovados = cursor.getString(cursor.getColumnIndexOrThrow("monto_renovados"));
                    String empleado_id = cursor.getString(cursor.getColumnIndexOrThrow("empleado_id"));
                    String fecha = cursor.getString(cursor.getColumnIndexOrThrow("fecha"));
                    String fecha_registro = cursor.getString(cursor.getColumnIndexOrThrow("fecha_registro"));
                    String status = cursor.getString(cursor.getColumnIndexOrThrow("status"));

                } while (cursor.moveToNext());
            } else {
                Log.d("UltimosRegistros", "No hay registros en la tabla reporte_creditos.");
            }

        } catch (Exception e) {
            Log.e("SQLiteError", "Error al obtener los últimos registros: ", e);
        } finally {
            if (cursor != null) cursor.close();
            if (db != null) db.close();
        }
    }

    private void getReporteCreditos(String ruta_id, String fecha, String empleado_id) {
        DatabaseHelper dbHelper = new DatabaseHelper(requireActivity());
        SQLiteDatabase db = dbHelper.getReadableDatabase();
        Cursor cursor = null;

        String whereClause = "";
        ArrayList<String> selectionArgs = new ArrayList<>();
        logUltimosTresRegistros();
        // Construir las condiciones de la consulta
        if (ruta_id != null && !ruta_id.isEmpty()) {
            whereClause += " AND poblaciones.ruta_id = ?";
            selectionArgs.add(ruta_id);
        }

        if (empleado_id != null && !empleado_id.isEmpty()) {
            whereClause += " AND rc.empleado_id = ?";
            selectionArgs.add(empleado_id);
        }

        if (fecha != null && !fecha.isEmpty()) {
            whereClause += " AND rc.fecha = ?";
            selectionArgs.add(fecha);
        }

        // Consulta SQL para obtener los datos
        String query = "SELECT poblaciones.nombre_poblacion, poblaciones.ruta_id, rc.* " +
                "FROM reporte_creditos AS rc " +
                "INNER JOIN poblaciones ON poblaciones.id = rc.poblacion_id " +
                whereClause + " ORDER BY rc.poblacion_id DESC";

        // Ejecutar la consulta
        cursor = db.rawQuery(query, selectionArgs.toArray(new String[0]));

        // Lista para almacenar los resultados
        reporteCreditos = new ArrayList<>();

        // Procesar el resultado
        if (cursor.moveToFirst()) {
            do {
                // Crear un nuevo objeto ReporteCreditos y llenar con los datos del cursor
                ReporteCreditos reporteCredito = new ReporteCreditos();
                reporteCredito.setId(cursor.getString(cursor.getColumnIndexOrThrow("id")));
                reporteCredito.setNombre_poblacion(cursor.getString(cursor.getColumnIndexOrThrow("nombre_poblacion")));
                reporteCredito.setRuta_id(cursor.getString(cursor.getColumnIndexOrThrow("ruta_id")));
                reporteCredito.setEmpleado_id(cursor.getString(cursor.getColumnIndexOrThrow("empleado_id")));
                reporteCredito.setPoblacion_id(cursor.getString(cursor.getColumnIndexOrThrow("poblacion_id")));
                reporteCredito.setObservaciones(cursor.getString(cursor.getColumnIndexOrThrow("observaciones")));
                reporteCredito.setCreditos_otorgados(cursor.getString(cursor.getColumnIndexOrThrow("creditos_otorgados")));
                reporteCredito.setTotal_prestamos(cursor.getString(cursor.getColumnIndexOrThrow("total_prestamos")));
                reporteCredito.setPrestamos_nuevos(cursor.getString(cursor.getColumnIndexOrThrow("prestamos_nuevos")));
                reporteCredito.setMonto_nuevos(cursor.getString(cursor.getColumnIndexOrThrow("monto_nuevos")));
                reporteCredito.setPrestamos_renovados(cursor.getString(cursor.getColumnIndexOrThrow("prestamos_renovados")));
                reporteCredito.setMonto_renovados(cursor.getString(cursor.getColumnIndexOrThrow("monto_renovados")));
                reporteCredito.setFecha(cursor.getString(cursor.getColumnIndexOrThrow("fecha")));
                reporteCredito.setFecha_registro(cursor.getString(cursor.getColumnIndexOrThrow("fecha_registro")));

                reporteCreditos.add(reporteCredito);
            } while (cursor.moveToNext());
        }

        cursor.close();
        db.close();

        // Aquí puedes proceder a mostrar los datos (reporteCreditos) en tu UI
        if (!reporteCreditos.isEmpty()) {
            // Llamar al adaptador para agregar los resultados al RecyclerView
            reporteCreditosAdapter.clear();
            reporteCreditosAdapter.addAll(reporteCreditos);
            reporteCreditosAdapter.notifyItemRangeChanged(reporteCreditos.size(), 1);

            // Mostrar botones si hay resultados
            btnTotales.setVisibility(View.VISIBLE);
            btnGuardar.setVisibility(View.VISIBLE);
            btnAgregar.setVisibility(View.VISIBLE);
        } else {
            // Mostrar mensaje si no hay resultados
            btnTotales.setVisibility(View.GONE);
            btnGuardar.setVisibility(View.GONE);
            btnAgregar.setVisibility(View.GONE);
            Toast.makeText(getActivity(), "No existe ningun reporte con los filtros ingresados", Toast.LENGTH_SHORT).show();
        }
    }


    /*
    private void getReporteCreditos(String ruta_id, String fecha, String empleado_id)
    {
        ProgressDialog dialog = new ProgressDialog(getActivity(),  R.style.AppMaterialAlertDialogStyle);
        dialog.setMessage("Cargando datos, por favor espere...");
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();

        vs = VolleyS.getInstance(getActivity());
        requestQueue = vs.getRequestQueue();

        JSONObject data = new JSONObject();
        try {
            data.put("func", "getReporteCreditos");
            data.put("ruta", ruta_id);
            data.put("fecha", fecha);
            data.put("empleado", empleado_id);
        } catch (JSONException e) {
            e.printStackTrace();
        }

        JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlPagos, data,
                new Response.Listener<JSONObject>() {

                    @Override
                    public void onResponse(JSONObject response) {

                        try {

                            dialog.cancel();
                            //String data = response.get("data").toString();
                            JSONArray data = (JSONArray) response.get("data");

                            Log.d("DATA", data.toString());

                            reporteCreditosAdapter.clear();
                            reporteCreditos.clear();

                            if(data.length() > 0){

                                btnTotales.setVisibility(View.VISIBLE);
                                btnGuardar.setVisibility(View.VISIBLE);
                                btnAgregar.setVisibility(View.VISIBLE);


                                for(int i = 0; i < data.length(); i++){

                                    JSONObject obj = data.getJSONObject(i);

                                    Gson gson = new Gson();
                                    ReporteCreditos reporteCredito = gson.fromJson(obj.toString(), ReporteCreditos.class);
                                    reporteCreditos.add(reporteCredito);

                                }
                            }
                            else{
                                btnAgregar.setVisibility(View.GONE);
                                btnTotales.setVisibility(View.GONE);
                                btnGuardar.setVisibility(View.GONE);
                                Toast.makeText(getActivity(), "No existe ningun reporte con los filtros ingresados", Toast.LENGTH_SHORT).show();
                            }

                            reporteCreditosAdapter.addAll(reporteCreditos);
                            reporteCreditosAdapter.notifyItemRangeChanged(reporteCreditos.size(), 1);

                        } catch (JSONException e) {
                            e.printStackTrace();
                        }

                    }
                }, new Response.ErrorListener() {

            @Override
            public void onErrorResponse(VolleyError error) {

                dialog.cancel();
                ErrorChecker.checker(error, getActivity());

            }
        }) ;

        request.setRetryPolicy(new DefaultRetryPolicy(
                5000,
                DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

        request.setShouldCache(false);
        requestQueue.add(request);

    }
    */

    private void getNuevoReporteDiarioRutas(String ruta_id) {
        ProgressDialog dialog = new ProgressDialog(getActivity(), R.style.AppMaterialAlertDialogStyle);
        dialog.setMessage("Cargando datos, por favor espere...");
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();

        // Acceder a la base de datos SQLite
        SQLiteDatabase db = new DatabaseHelper(getActivity()).getReadableDatabase();

        // Construir la consulta SQL
        String whereClause = "WHERE (CASE " +
                "WHEN prestamos.status = 2 AND DATE(prestamos.updated_at) = DATE('now') THEN prestamos.status IN (0, 2) " +
                "ELSE prestamos.status = 0 END)";

        if (ruta_id != null && !ruta_id.isEmpty()) {
            whereClause += " AND clientes.ruta_id = ?";
        }

        String query = "SELECT " +
                "TABLA_ESTIMADOS.poblacion_id, " +
                "TABLA_ESTIMADOS.ruta_id, " +
                "TABLA_ESTIMADOS.nombre_poblacion, " +
                "TABLA_ESTIMADOS.modalidad_semanas, " +
                "SUM(TABLA_ESTIMADOS.cantidad_esperada_pago) AS estimado, " +
                "'' AS estimacion, " +
                "'' AS abonos_semana, " +
                "'' AS recuperacion_semana, " +
                "'' AS anticipos, " +
                "'' AS total_1, " +
                "'' AS recuperacion_prestamos, " +
                "'' AS colocacion, " +
                "'' AS prestamo_colocadora, " +
                "'' AS comision, " +
                "'' AS bono_colocadora, " +
                "'' AS total_2, " +
                "'' AS saldo, " +
                "'' AS pendiente_recuperar, " +
                "'' AS abonos_recuperar, " +
                "'' AS empleado_id, " +
                "'' AS gastos_id, " +
                "'' AS fecha, " +
                "'' AS fecha_registro " +
                "FROM ( " +
                "    SELECT " +
                "        pagos.cantidad_esperada_pago, " +
                "        pagos.semana, " +
                "        poblaciones.primer_dia_cobro, " +
                "        MAX(CASE WHEN pagos.fecha_pago >= DATE('now') AND pagos.fecha_pago < DATE('now', '+7 days') THEN pagos.fecha_pago END) AS fecha_pago, " +
                "        clientes.nombre_completo, " +
                "        clientes.poblacion_id, " +
                "        clientes.ruta_id, " +
                "        prestamos.grupo_poblacion, " +
                "        prestamos.modalidad_semanas, " +
                "        poblaciones.nombre_poblacion, " +
                "        rutas.nombre_ruta, " +
                "        prestamos.status, " +
                "        prestamos.updated_at " +
                "    FROM pagos " +
                "    INNER JOIN prestamos ON prestamos.id = pagos.prestamo_id " +
                "    INNER JOIN clientes ON clientes.id = prestamos.cliente_id " +
                "    INNER JOIN poblaciones ON poblaciones.id = clientes.poblacion_id " +
                "    INNER JOIN rutas ON rutas.id = clientes.ruta_id " +
                whereClause + " " +
                "    GROUP BY prestamos.id " +
                "    ORDER BY clientes.poblacion_id DESC " +
                ") AS TABLA_ESTIMADOS " +
                "GROUP BY TABLA_ESTIMADOS.nombre_poblacion " +
                "ORDER BY TABLA_ESTIMADOS.poblacion_id DESC";

        // Argumentos para la cláusula WHERE
        String[] selectionArgs = (ruta_id != null && !ruta_id.isEmpty()) ? new String[]{ruta_id} : null;

        // Ejecutar la consulta
        Cursor cursor = db.rawQuery(query, selectionArgs);

        // Lista para almacenar los resultados
        reporteCreditos = new ArrayList<>();

        try {
            if (cursor.moveToFirst()) {
                do {
                    ReporteCreditos reporteCredito = new ReporteCreditos();
                    // Mapeo de todos los campos
                    reporteCredito.setPoblacion_id(cursor.getString(cursor.getColumnIndexOrThrow("poblacion_id")));
                    reporteCredito.setRuta_id(cursor.getString(cursor.getColumnIndexOrThrow("ruta_id")));
                    reporteCredito.setNombre_poblacion(cursor.getString(cursor.getColumnIndexOrThrow("nombre_poblacion")));
                    //reporteCredito.setModalidadSemanas(cursor.getString(cursor.getColumnIndexOrThrow("modalidad_semanas")));
                    //reporteCredito.setEstimado(cursor.getDouble(cursor.getColumnIndexOrThrow("estimado")));
                    //reporteCredito.setEstimacion(cursor.getString(cursor.getColumnIndexOrThrow("estimacion")));
                    //reporteCredito.setAbonosSemana(cursor.getString(cursor.getColumnIndexOrThrow("abonos_semana")));
                    //reporteCredito.setRecuperacion_Semana(cursor.getString(cursor.getColumnIndexOrThrow("recuperacion_semana")));
                    //reporteCredito.setAnticipos(cursor.getString(cursor.getColumnIndexOrThrow("anticipos")));
                    //reporteCredito.setTotal1(cursor.getString(cursor.getColumnIndexOrThrow("total_1")));
                    //reporteCredito.setRecuperacionPrestamos(cursor.getString(cursor.getColumnIndexOrThrow("recuperacion_prestamos")));
                    //reporteCredito.setColocacion(cursor.getString(cursor.getColumnIndexOrThrow("colocacion")));
                    //reporteCredito.setPrestamoColocadora(cursor.getString(cursor.getColumnIndexOrThrow("prestamo_colocadora")));
                    //reporteCredito.setComision(cursor.getString(cursor.getColumnIndexOrThrow("comision")));
                    //reporteCredito.setBonoColocadora(cursor.getString(cursor.getColumnIndexOrThrow("bono_colocadora")));
                    //reporteCredito.setTotal2(cursor.getString(cursor.getColumnIndexOrThrow("total_2")));
                    //reporteCredito.setSaldo(cursor.getString(cursor.getColumnIndexOrThrow("saldo")));
                    //reporteCredito.setPendienteRecuperar(cursor.getString(cursor.getColumnIndexOrThrow("pendiente_recuperar")));
                    //reporteCredito.setAbonosRecuperar(cursor.getString(cursor.getColumnIndexOrThrow("abonos_recuperar")));
                    reporteCredito.setEmpleado_id(cursor.getString(cursor.getColumnIndexOrThrow("empleado_id")));
                    //reporteCredito.setGastosId(cursor.getString(cursor.getColumnIndexOrThrow("gastos_id")));
                    reporteCredito.setFecha(cursor.getString(cursor.getColumnIndexOrThrow("fecha")));
                    reporteCredito.setFecha_registro(cursor.getString(cursor.getColumnIndexOrThrow("fecha_registro")));

                    reporteCreditos.add(reporteCredito);
                } while (cursor.moveToNext());
            }
        } finally {
            cursor.close();
            db.close();
        }

        dialog.cancel();

        // Actualizar la interfaz de usuario con los datos
        if (!reporteCreditos.isEmpty()) {
            btnTotales.setVisibility(View.VISIBLE);
            btnGuardar.setVisibility(View.VISIBLE);

            reporteCreditosAdapter.clear();
            reporteCreditosAdapter.addAll(reporteCreditos);
            reporteCreditosAdapter.notifyItemRangeChanged(reporteCreditos.size(), 1);
        } else {
            btnTotales.setVisibility(View.GONE);
            btnGuardar.setVisibility(View.GONE);
            Toast.makeText(getActivity(), "No se encontraron reportes para esta ruta.", Toast.LENGTH_SHORT).show();
        }
    }


    private void registrarReporte(ReporteCreditos reporteCreditos){

        vs = VolleyS.getInstance(getActivity());
        requestQueue = vs.getRequestQueue();

        JSONObject data = new JSONObject();
        try {
            data.put("func", "createReporteCreditos");
            data.put("poblacion_id", reporteCreditos.getPoblacion_id());
            data.put("observaciones", reporteCreditos.getObservaciones());
            data.put("creditos_otorgados", reporteCreditos.getCreditos_otorgados());
            data.put("total_prestamos", reporteCreditos.getTotal_prestamos());
            data.put("prestamos_nuevos", reporteCreditos.getPrestamos_nuevos());
            data.put("montos_nuevos", reporteCreditos.getMonto_nuevos());
            data.put("prestamos_renovados", reporteCreditos.getPrestamos_renovados());
            data.put("montos_renovados", reporteCreditos.getMonto_renovados());
            data.put("empleado_id", sesion.getString("id", ""));
            data.put("fecha", tlFecha.getEditText().getText().toString());

        } catch (JSONException e) {
            e.printStackTrace();
        }
        String freg =  tlFecha.getEditText().getText().toString();

        JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlPagos, data,
                new Response.Listener<JSONObject>() {

                    @Override
                    public void onResponse(JSONObject response) {

                        try {

                            if (response.getString("status").equals("success")) {
                                // Obtener el campo updated_at del servidor
                                String id = response.getJSONObject("data").getString("id");

                                registrarReporteCreditosEnSQLite(reporteCreditos.getPoblacion_id(), reporteCreditos.getObservaciones(), reporteCreditos.getCreditos_otorgados(),
                                        reporteCreditos.getTotal_prestamos(), reporteCreditos.getPrestamos_nuevos(), reporteCreditos.getMonto_nuevos(),
                                        reporteCreditos.getPrestamos_renovados(), reporteCreditos.getMonto_renovados(), sesion.getString("id", ""),
                                        freg, id, "on");
                            }

                        } catch (JSONException e) {
                            e.printStackTrace();
                        }

                    }
                }, new Response.ErrorListener() {

            @Override
            public void onErrorResponse(VolleyError error) {

                ErrorChecker.checker(error, getActivity());
                registrarReporteCreditosEnSQLite(reporteCreditos.getPoblacion_id(), reporteCreditos.getObservaciones(), reporteCreditos.getCreditos_otorgados(),
                        reporteCreditos.getTotal_prestamos(), reporteCreditos.getPrestamos_nuevos(), reporteCreditos.getMonto_nuevos(),
                        reporteCreditos.getPrestamos_renovados(), reporteCreditos.getMonto_renovados(), sesion.getString("id", ""),
                        freg, "", "off");
            }
        }) ;

        request.setRetryPolicy(new DefaultRetryPolicy(
                0,
                DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

        request.setShouldCache(false);
        requestQueue.add(request);

    }

    private void registrarReporteCreditosEnSQLite(String poblacion_id, String observaciones, String creditos_otorgados, String total_prestamos,
                                                  String prestamos_nuevos, String monto_nuevos, String prestamos_renovados, String monto_renovados,
                                                  String empleado_id, String fecha, String idServer, String online) {

        // Abrimos la base de datos para escritura
        DatabaseHelper dbHelper = new DatabaseHelper(requireContext());
        SQLiteDatabase db = dbHelper.getWritableDatabase();

        // Usamos la línea sugerida para asignar el idReporte
        String idReporte = (idServer != null && !idServer.isEmpty()) ? idServer : String.valueOf(obtenerSiguienteIdReporte(db));

        // Crear el ContentValues para insertar el cliente
        ContentValues valores = new ContentValues();
        valores.put("id", idReporte); // Asignamos el nuevo ID
        valores.put("poblacion_id", poblacion_id);
        valores.put("observaciones", observaciones);
        valores.put("creditos_otorgados", (creditos_otorgados == null || creditos_otorgados.trim().isEmpty()) ? "0" : creditos_otorgados);
        valores.put("total_prestamos", (total_prestamos == null || total_prestamos.trim().isEmpty()) ? "0" : total_prestamos);
        valores.put("prestamos_nuevos", (prestamos_nuevos == null || prestamos_nuevos.trim().isEmpty()) ? "0" : prestamos_nuevos);
        valores.put("monto_nuevos", (monto_nuevos == null || monto_nuevos.trim().isEmpty()) ? "0" : monto_nuevos);
        valores.put("prestamos_renovados", (prestamos_renovados == null || prestamos_renovados.trim().isEmpty()) ? "0" : prestamos_renovados);
        valores.put("monto_renovados", (monto_renovados == null || monto_renovados.trim().isEmpty()) ? "0" : monto_renovados);
        valores.put("empleado_id", empleado_id);
        valores.put("fecha", fecha);

        // Establecemos el estado "status" dependiendo del valor de "online"
        if (online != "off") {
            valores.put("status", "0");
        } else {
            valores.put("status", "1");
        }

        // Restamos 10 minutos de la fecha actual
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("America/Mexico_City"));  // Especificamos la zona horaria de México
        calendar.add(Calendar.MINUTE, -10);
        Date nuevaFecha = calendar.getTime();

// Formateamos la fecha en el formato adecuado
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.forLanguageTag("es-MX")); // Establecer locale para México
        String fechaRestada = dateFormat.format(nuevaFecha);

        valores.put("fecha_registro", fechaRestada);

        // Insertar el nuevo cliente en la base de datos
        long resultado = db.insert("reporte_creditos", null, valores);

        if (resultado != -1) {
            Log.d("SQLite", "reporte registrado con éxito en SQLite con ID: " + idReporte);
        } else {
            Log.d("SQLite", "Error al registrar el reporte en SQLite.");
        }

        db.close(); // Cerrar la conexión a la base de datos
    }


    // Método para obtener el siguiente ID disponible en la tabla clientes
    private int obtenerSiguienteIdReporte(SQLiteDatabase db) {
        int ultimoId = 0;
        Cursor cursor = db.rawQuery("SELECT MAX(id) FROM reporte_creditos", null);

        if (cursor.moveToFirst()) {
            ultimoId = cursor.getInt(0);
        }
        cursor.close();

        return ultimoId + 1;
    }

    private void filtrarReporte(String ruta_id){

        reporteCreditosFiltrado = new ArrayList<>();
        reporteCreditosFiltrado.clear();

        for(ReporteCreditos rc: reporteCreditos){

            if(rc.getRuta_id().equals(ruta_id)){
                reporteCreditosFiltrado.add(rc);
            }

        }

        if(!reporteCreditosFiltrado.isEmpty()){
            reporteCreditosAdapter.setListaFiltrada( reporteCreditosFiltrado);
        }

    }

    private void filtrarReportePoblaciones(String text){

        if(reporteCreditosFiltrado.size() == 0){

            for(ReporteCreditos rd: reporteCreditos){
                if(rd.getNombre_poblacion().toLowerCase().contains(text.toLowerCase())){
                    reporteCreditosFiltrado.add(rd);
                }
            }

            if(!reporteCreditosFiltrado.isEmpty()){
                reporteCreditosAdapter.setListaFiltrada(reporteCreditosFiltrado);
            }

        }
        else{
            reportesFiltradosNombres = new ArrayList<>();

            for(ReporteCreditos rd: reporteCreditosFiltrado){
                if(rd.getNombre_poblacion().toLowerCase().contains(text.toLowerCase())){
                    reportesFiltradosNombres.add(rd);
                }
            }

            if(!reportesFiltradosNombres.isEmpty()){
                reporteCreditosAdapter.setListaFiltrada(reportesFiltradosNombres);
            }
        }

    }

    private void getPoblaciones(String ruta_id) {
        if (poblacionController.obtener().size() == 0) {

            vs = VolleyS.getInstance(this.getContext());
            requestQueue = vs.getRequestQueue();

            JSONObject data = new JSONObject();
            try {
                data.put("func", "index");
            } catch (JSONException e) {
                e.printStackTrace();
            }

            JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlPoblaciones, data,
                    new Response.Listener<JSONObject>() {

                        @Override
                        public void onResponse(JSONObject response) {
                            try {

                                JSONArray data = (JSONArray) response.get("data");

                                for (int i = 0; i < data.length(); i++) {

                                    JSONObject obj = data.getJSONObject(i);

                                    Gson gson = new Gson();
                                    Poblacion poblacion = gson.fromJson(obj.toString(), Poblacion.class);

                                    poblaciones.add(poblacion);
                                    poblacionController.nueva(poblacion);

                                }

                                poblacionesAdapter = new ArrayAdapter<Poblacion>(getContext(), android.R.layout.simple_dropdown_item_1line, poblaciones);


                            } catch (JSONException e) {
                                e.printStackTrace();
                            }
                        }
                    }, new Response.ErrorListener() {

                @Override
                public void onErrorResponse(VolleyError error) {

                    ErrorChecker.checker(error, getActivity());

                }
            });

            request.setRetryPolicy(new DefaultRetryPolicy(
                    0,
                    DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                    DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

            requestQueue.add(request);
        } else {
            poblaciones = poblacionController.obtener();

            poblacionesAdapter = new ArrayAdapter<Poblacion>(getContext(), android.R.layout.simple_dropdown_item_1line, poblaciones);

        }
    }

    private void agregarRegistroReporte(ReporteCreditos reporteCredito){

        vs = VolleyS.getInstance(getActivity());
        requestQueue = vs.getRequestQueue();

        JSONObject data = new JSONObject();
        try {
            data.put("func", "createReporteCreditos");
            data.put("poblacion_id", reporteCredito.getPoblacion_id());
            data.put("observaciones", reporteCredito.getObservaciones());
            data.put("creditos_otorgados", reporteCredito.getCreditos_otorgados());
            data.put("total_prestamos", (reporteCredito.getTotal_prestamos() == null || reporteCredito.getTotal_prestamos().isEmpty()) ? 0 : Integer.parseInt(reporteCredito.getTotal_prestamos()));
            data.put("prestamos_nuevos", (reporteCredito.getPrestamos_nuevos() == null || reporteCredito.getPrestamos_nuevos().isEmpty()) ? 0 : Integer.parseInt(reporteCredito.getPrestamos_nuevos()));
            data.put("montos_nuevos", (reporteCredito.getMonto_nuevos() == null || reporteCredito.getMonto_nuevos().isEmpty()) ? 0 : Integer.parseInt(reporteCredito.getMonto_nuevos()));
            data.put("prestamos_renovados", (reporteCredito.getPrestamos_renovados() == null || reporteCredito.getPrestamos_renovados().isEmpty()) ? 0 : Integer.parseInt(reporteCredito.getPrestamos_renovados()));
            data.put("montos_renovados", (reporteCredito.getMonto_renovados() == null || reporteCredito.getMonto_renovados().isEmpty()) ? 0 : Integer.parseInt(reporteCredito.getMonto_renovados()));
            data.put("empleado_id", sesion.getString("id", "0"));
            data.put("fecha", tlFecha.getEditText().getText().toString());

        } catch (JSONException e) {
            e.printStackTrace();
        }
        String fechaAgregar = tlFecha.getEditText().getText().toString();
        JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlPagos, data,
                new Response.Listener<JSONObject>() {

                    @Override
                    public void onResponse(JSONObject response) {

                        try {

                            if (response.getString("status").equals("success")) {
                                // Obtener el campo updated_at del servidor
                                String id = response.getJSONObject("data").getString("id");

                            registrarReporteCreditosEnSQLite(reporteCredito.getPoblacion_id(), reporteCredito.getObservaciones(), reporteCredito.getCreditos_otorgados(),
                                    (reporteCredito.getTotal_prestamos() == null || reporteCredito.getTotal_prestamos().isEmpty()) ? "0" : reporteCredito.getTotal_prestamos(),
                                    (reporteCredito.getPrestamos_nuevos() == null || reporteCredito.getPrestamos_nuevos().isEmpty()) ? "0" : reporteCredito.getPrestamos_nuevos(),
                                    (reporteCredito.getMonto_nuevos() == null || reporteCredito.getMonto_nuevos().isEmpty()) ? "0" : reporteCredito.getMonto_nuevos(),
                                    (reporteCredito.getPrestamos_renovados() == null || reporteCredito.getPrestamos_renovados().isEmpty()) ? "0" : reporteCredito.getPrestamos_renovados(),
                                    (reporteCredito.getMonto_renovados() == null || reporteCredito.getMonto_renovados().isEmpty()) ? "0" : reporteCredito.getMonto_renovados(),
                                    sesion.getString("id", ""),
                                    fechaAgregar, id, "on");
                            getReporteCreditos(ruta_id, tlFecha.getEditText().getText().toString(), sesion.getString("id",""));
                            }
                        } catch (JSONException e) {
                            e.printStackTrace();
                        }

                    }
                }, new Response.ErrorListener() {

            @Override
            public void onErrorResponse(VolleyError error) {
                ErrorChecker.checker(error, getActivity());
                registrarReporteCreditosEnSQLite(reporteCredito.getPoblacion_id(), reporteCredito.getObservaciones(), reporteCredito.getCreditos_otorgados(),
                        (reporteCredito.getTotal_prestamos() == null || reporteCredito.getTotal_prestamos().isEmpty()) ? "0" : reporteCredito.getTotal_prestamos(),
                        (reporteCredito.getPrestamos_nuevos() == null || reporteCredito.getPrestamos_nuevos().isEmpty()) ? "0" : reporteCredito.getPrestamos_nuevos(),
                        (reporteCredito.getMonto_nuevos() == null || reporteCredito.getMonto_nuevos().isEmpty()) ? "0" : reporteCredito.getMonto_nuevos(),
                        (reporteCredito.getPrestamos_renovados() == null || reporteCredito.getPrestamos_renovados().isEmpty()) ? "0" : reporteCredito.getPrestamos_renovados(),
                        (reporteCredito.getMonto_renovados() == null || reporteCredito.getMonto_renovados().isEmpty()) ? "0" : reporteCredito.getMonto_renovados(),
                        sesion.getString("id", ""),
                        fechaAgregar, "", "off");
            }
        }) ;

        request.setRetryPolicy(new DefaultRetryPolicy(
                0,
                DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

        request.setShouldCache(false);
        requestQueue.add(request);
    }

    private void editarRegistroReporte(ReporteCreditos reporteCredito){

        vs = VolleyS.getInstance(getActivity());
        requestQueue = vs.getRequestQueue();

        JSONObject data = new JSONObject();
        try {
            data.put("func", "editReporteCreditos");
            data.put("id", reporteCredito.getId());
            data.put("observaciones", reporteCredito.getObservaciones());
            data.put("creditos_otorgados", TextUtils.isEmpty(reporteCredito.getCreditos_otorgados()) ? "0" : reporteCredito.getCreditos_otorgados());
            data.put("total_prestamos", TextUtils.isEmpty(reporteCredito.getTotal_prestamos()) ? "0" : reporteCredito.getTotal_prestamos());
            data.put("prestamos_nuevos", TextUtils.isEmpty(reporteCredito.getPrestamos_nuevos()) ? "0" : reporteCredito.getPrestamos_nuevos());
            data.put("monto_nuevos", TextUtils.isEmpty(reporteCredito.getMonto_nuevos()) ? "0" : reporteCredito.getMonto_nuevos());
            data.put("prestamos_renovados", TextUtils.isEmpty(reporteCredito.getPrestamos_renovados()) ? "0" : reporteCredito.getPrestamos_renovados());
            data.put("monto_renovados", TextUtils.isEmpty(reporteCredito.getMonto_renovados()) ? "0" : reporteCredito.getMonto_renovados());
        } catch (JSONException e) {
            e.printStackTrace();
        }
        JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlPagos, data,
                new Response.Listener<JSONObject>() {

                    @Override
                    public void onResponse(JSONObject response) {

                        try {
                            String message = (String) response.get("message");
                            actualizarReporteEnSQLite(reporteCredito.getId(), reporteCredito.getObservaciones(),
                                    TextUtils.isEmpty(reporteCredito.getCreditos_otorgados()) ? "0" : reporteCredito.getCreditos_otorgados(),
                                    TextUtils.isEmpty(reporteCredito.getTotal_prestamos()) ? "0" : reporteCredito.getTotal_prestamos(),
                                    TextUtils.isEmpty(reporteCredito.getPrestamos_nuevos()) ? "0" : reporteCredito.getPrestamos_nuevos(),
                                    TextUtils.isEmpty(reporteCredito.getMonto_nuevos()) ? "0" : reporteCredito.getMonto_nuevos(),
                                    TextUtils.isEmpty(reporteCredito.getPrestamos_renovados()) ? "0" : reporteCredito.getPrestamos_renovados(),
                                    TextUtils.isEmpty(reporteCredito.getMonto_renovados()) ? "0" : reporteCredito.getMonto_renovados(),
                                    "on"
                            );
                            getReporteCreditos(ruta_id, tlFecha.getEditText().getText().toString(), sesion.getString("id",""));

                        } catch (JSONException e) {
                            e.printStackTrace();
                        }

                    }
                }, new Response.ErrorListener() {

            @Override
            public void onErrorResponse(VolleyError error) {

                ErrorChecker.checker(error, getActivity());
                actualizarReporteEnSQLite(reporteCredito.getId(), reporteCredito.getObservaciones(),
                        TextUtils.isEmpty(reporteCredito.getCreditos_otorgados()) ? "0" : reporteCredito.getCreditos_otorgados(),
                        TextUtils.isEmpty(reporteCredito.getTotal_prestamos()) ? "0" : reporteCredito.getTotal_prestamos(),
                        TextUtils.isEmpty(reporteCredito.getPrestamos_nuevos()) ? "0" : reporteCredito.getPrestamos_nuevos(),
                        TextUtils.isEmpty(reporteCredito.getMonto_nuevos()) ? "0" : reporteCredito.getMonto_nuevos(),
                        TextUtils.isEmpty(reporteCredito.getPrestamos_renovados()) ? "0" : reporteCredito.getPrestamos_renovados(),
                        TextUtils.isEmpty(reporteCredito.getMonto_renovados()) ? "0" : reporteCredito.getMonto_renovados(),
                        "off"
                );
                getReporteCreditos(ruta_id, tlFecha.getEditText().getText().toString(), sesion.getString("id",""));
            }
        }) ;

        request.setRetryPolicy(new DefaultRetryPolicy(
                0,
                DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

        request.setShouldCache(false);
        requestQueue.add(request);

    }
    private void actualizarReporteEnSQLite(String id, String observaciones, String creditos_otorgados, String total_prestamos, String prestamos_nuevos,
                                           String monto_nuevos, String prestamos_renovados, String monto_renovados, String online) {
        // Crear o abrir la base de datos
        DatabaseHelper dbHelper = new DatabaseHelper(getActivity());
        SQLiteDatabase db = dbHelper.getWritableDatabase();

        try {
            // Crear un objeto ContentValues con los valores a actualizar
            ContentValues valores = new ContentValues();
            valores.put("observaciones", observaciones);
            valores.put("creditos_otorgados", creditos_otorgados);
            valores.put("total_prestamos", total_prestamos);
            valores.put("prestamos_nuevos", prestamos_nuevos);
            valores.put("monto_nuevos", monto_nuevos);
            valores.put("prestamos_renovados", prestamos_renovados);
            valores.put("monto_renovados", monto_renovados);

            long timestamp = System.currentTimeMillis();

            if(online!="off")
            {
                valores.put("status", "0");
                timestamp -= 10000; // - 10 segundos = 10,000 milisegundos
            }
            else
            {
                valores.put("status", "2");
                timestamp += 10000; // + 10 segundos = 10,000 milisegundos
            }

            // Formatear la nueva hora
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
            String formattedDate = sdf.format(new Date(timestamp));

            valores.put("fecha_registro", formattedDate);

            // Actualizar el registro en la base de datos
            int filasActualizadas = db.update(
                    "reporte_creditos",           // Nombre de la tabla
                    valores,                          // Nuevos valores
                    "id = ?",                         // Clausula WHERE
                    new String[]{id} // Argumento para WHERE
            );

            // Verificar si la actualización fue exitosa
            if (filasActualizadas > 0) {
                Log.d("SQLite", "Reporte actualizado con éxito en SQLite con ID: " + id);
            } else {
                Log.d("SQLite", "No se encontró el reporte con ID: " + id + " para actualizar.");
            }
        } catch (Exception e) {
            e.printStackTrace();
            Log.d("SQLite", "Error al actualizar el reporte en SQLite: " + e.getMessage());
        } finally {
            db.close(); // Cerrar la conexión a la base de datos
        }
    }
}